jQuery(document).ready(function ($) {

	// Featured Equipment
	$(document).on("click", ".dr-featured-equipment", function (e) {
		e.preventDefault();
		var featuredIcon = $(this);
		var post_id = $(this).attr("data-post-id");
		var nonce = $(this).attr("data-nonce");
		var data = {
			action: "featured_equipment",
			post_id: post_id,
			nonce: nonce,
		};
		$.ajax({
			url: ajaxurl,
			data: data,
			type: "post",
			dataType: "json",
			success: function (data) {
				if (data != "invalid") {
					featuredIcon
						.removeClass("dashicons-star-filled")
						.removeClass("dashicons-star-empty");
					if (data.new_status == "yes") {
						featuredIcon.addClass("dashicons-star-filled");
					} else {
						featuredIcon.addClass("dashicons-star-empty");
					}
				}
			},
		});
	});

	(function () {
		function createRatingSystem(ratingContainerId) {
			const ratingContainer = document.getElementById(ratingContainerId);
			if (ratingContainer === null) {
				return;
			}
			const dynamicRating = ratingContainer.dataset.dynamicRating;
			const stars = ratingContainer.querySelectorAll('.star');
			const ratingInputField = ratingContainer.parentElement.querySelector('input[name="rating"]');
			let selectedRating = ratingInputField ? ratingInputField.value : dynamicRating;
			stars.forEach(star => star.querySelector('path').setAttribute('fill', 'none'));
			for (let i = 1; i <= selectedRating; i++) {
				stars[i - 1].querySelector('path').setAttribute('fill', '#FFAE34');
			}
			stars.forEach(star => {
				star.addEventListener('mouseover', () => {
					const rating = star.getAttribute('data-rating');
					stars.forEach(star => star.querySelector('path').setAttribute('fill', 'none'));
					for (let i = 1; i <= rating; i++) {
						stars[i - 1].querySelector('path').setAttribute('fill', '#FFAE34');
					}
				});
				star.addEventListener('mouseout', () => {
					stars.forEach(star => star.querySelector('path').setAttribute('fill', 'none'));
					for (let i = 1; i <= selectedRating; i++) {
						stars[i - 1].querySelector('path').setAttribute('fill', '#FFAE34');
					}
				});
				star.addEventListener('click', () => {
					selectedRating = star.getAttribute('data-rating');
					if (ratingInputField) {
						ratingInputField.setAttribute('value', selectedRating)
					}
				});
			});
		}
		createRatingSystem('admin-edit-rating-container');
	})();

	$(document).on("click", "button.dr-review-add-images", function (e) {
		$this = $(this);
		e.preventDefault();
		var file_frame;
		var allowed_filetype = ["image/jpeg", "image/png", "image/webp"];
		if (file_frame) file_frame.close();

		file_frame = wp.media.frames.file_frame = wp.media({
			title: $(this).data('uploader-title'),
			button: {
				text: $(this).data('uploader-button-text'),
			},
			library: {
				type: allowed_filetype,
			},
			multiple: true,
		});

		file_frame.on("select", function () {
			var selection = file_frame.state().get("selection");
			selection.map(function (attachment, i) {
				var attachment = attachment.toJSON();
				$("#dr-tax-image-wrapper").html(
					'<img src="' + attachment.sizes.thumbnail.url + '"/>'
				);
				$(".dr_tax_image_media_id").val(attachment.id);
				$this.parent().find('.dr-recipe-review-gallery').append('<li>'
					+ '<input type="hidden" class"recipe-gallery" name="gallery_images[]" value="' + attachment.id + '">'
					+ '<img class="dr-image-preview" src="' + attachment.sizes.thumbnail.url + '">'
					+ '<div class="dr-gal-btns">'
					+ '<button type="button" class="dr-change" href="#" data-uploader-title="Change image" data-uploader-button-text="Change image" title="Change Image">Replace</button>'
					+ '<button type="button" class="dr-delete" href="#">Delete</button>'
					+ '</div>'
					+ '</li>');
			});
		});

		file_frame.open();
	});

	$(document).on("click", ".dr-recipe-review-gallery button.dr-change", function (e) {
		$this = $(this);
		e.preventDefault();
		var file_frame;
		var allowed_filetype = ["image/jpeg", "image/png", "image/webp"];
		if (file_frame) file_frame.close();

		file_frame = wp.media.frames.file_frame = wp.media({
			title: $(this).data('uploader-title'),
			button: {
				text: $(this).data('uploader-button-text'),
			},
			library: {
				type: allowed_filetype,
			},
			multiple: false,
		});

		file_frame.on("select", function () {
			var selection = file_frame.state().get("selection");
			selection.map(function (attachment, i) {
				var attachment = attachment.toJSON();
				$this.closest('li').find('input:hidden').attr('value', attachment.id);
				$this.closest('li').find('img.dr-image-preview').attr('src', attachment.sizes.thumbnail.url);
			});
		});

		file_frame.open();
	});

	$(document).on("click", ".dr-recipe-review-gallery button.dr-delete", function (e) {
		e.preventDefault();
		$(this).closest('li').animate({ opacity: 0 }, 200, function () {
			$(this).remove();
		});
	});


	// Add css class to equipments and review pages if license is not activated
	$(window).on('load', function () {
		let licenseStatus = DeliciousRecipesProAdmin.licenseStatus;
		let bodyClass = $('body').attr('class');
		let bodyClassArray = bodyClass.split(' ');
		// const table = $('table.wp-list-table');
		if (bodyClassArray.includes('post-type-equipment') && !licenseStatus) {
			const addNewButton = $('a.page-title-action');
			if (addNewButton && addNewButton.text().trim() === "Add New Equipment") {
				addNewButton.attr('href', '#');
				addNewButton.css('pointer-events', 'none');
				addNewButton.css('color', 'none');
				addNewButton.css('cursor', 'not-allowed');
				addNewButton.after(`<span class='dr-license-deactivated-message'}>License Key is not activated</span>`);
			}

			const table = $('#posts-filter');
			const filters = $('.subsubsub');
			if (table && table.length > 0) {
				filters.css('pointer-events', 'none');
				filters.css('opacity', '0.5');
				table.css('pointer-events', 'none');
				table.css('opacity', '0.5');
			}
		}

		if (bodyClassArray.includes('wp-delicious_page_delicious_recipes_reviews') && !licenseStatus) {
			const table = $('#dr-reviews-page-wrapper');
			if (table && table.length > 0) {
				table.css({
					'pointer-events': 'none',
					'opacity': '0.5'
				});
			}
		}
	});

}); //document close