const dashboardPortal = () => {
    const wrap = document.querySelector('.wpd-dashboard-portal');
    if (wrap) {
        const userDropdownToggler = document.getElementById('wpd-dp__user-dropdown-toggler');
        const userWrap = document.querySelector('.wpd-dp__user-wrap');
        const sidebar = wrap.querySelector('.wpd-dashboard-portal__sidebar');
        const sidebarToggler = document.getElementById('wpd-dp__sidebar-toggler');
        const sidebarClose = document.getElementById('wpd-dp__sidebar-close');
        const tabButtons = wrap.querySelectorAll('.wpd-dp__tab-button');
        const tabContents = wrap.querySelectorAll('.wpd-dp__tab-content');

        // Utility Functions
        const updateUrlParam = (tabId) => {
            const url = new URL(window.location);
            url.searchParams.set('tab', tabId.replace('wpd-', ''));
            window.history.pushState({}, '', url);
        };

        const showCurrentTabContent = () => {
            tabContents.forEach((content) => {
                content.classList.remove('active');
            });

            const activeButton = wrap.querySelector('.wpd-dp__tab-button.active');
            if (activeButton) {
                const currentTab = activeButton.dataset.tab;
                const activeContent = wrap.querySelector(`.wpd-dp__tab-content[data-tab="${currentTab}"]`);
                if (activeContent) {
                    activeContent.classList.add('active');
                }
            }
        };

        const activateTab = (targetButton) => {
            // Skip if it's an external link
            if (targetButton.tagName.toLowerCase() === 'a' && targetButton.getAttribute('target') === '_blank') {
                return false;
            }

            // Remove active class from all buttons
            tabButtons.forEach(btn => btn.classList.remove('active'));
            
            // Activate the target button
            targetButton.classList.add('active');
            
            // Update titles
            const titles = document.querySelectorAll('.wpd-dp__title');
            titles.forEach(title => {
                title.textContent = targetButton.textContent.trim();
            });

            // Update URL and show content
            const tabId = targetButton.dataset.tab;
            updateUrlParam(tabId);
            showCurrentTabContent();

            return true;
        };

        // Function to set active tab based on URL
        const setActiveTabFromUrl = () => {
            const urlParams = new URLSearchParams(window.location.search);
            const tabParam = urlParams.get('tab');
            
            if (tabParam) {
                const tabId = `wpd-${tabParam}`;
                const targetButton = wrap.querySelector(`.wpd-dp__tab-button[data-tab="${tabId}"]`);
                
                if (targetButton) {
                    activateTab(targetButton);
                }
            }
        };

        // Initialize
        setActiveTabFromUrl();

        // Event Listeners
        tabButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                // Prevent default for buttons
                if (this.tagName.toLowerCase() === 'button') {
                    e.preventDefault();
                }
                activateTab(this);
            });
        });

        // Sidebar functionality
        const closeSidebar = () => {
            sidebar.classList.remove('open');
            wrap.classList.remove('sidebar-open');
        };

        const openSidebar = () => {
            sidebar.classList.add('open');
            wrap.classList.add('sidebar-open');
        };

        // User dropdown menu
        userDropdownToggler.addEventListener('click', () => {
            userWrap.classList.toggle('open');
        });

        // Sidebar toggle
        sidebarToggler.addEventListener('click', openSidebar);
        sidebarClose.addEventListener('click', closeSidebar);

        // Click outside handlers
        document.addEventListener('click', (e) => {
            if (!userWrap.contains(e.target) && e.target !== userDropdownToggler) {
                userWrap.classList.remove('open');
            }
            if (!sidebar.contains(e.target) && e.target !== sidebarToggler) {
                closeSidebar();
            }
        });
    }
};

export default dashboardPortal;