<?php
/**
 * Delicious Recipes Dashboard Portal Template
 *
 * @package WP_Delicious_Recipes
 * @since 2.2.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Load WordPress header functionality without the header template.
if ( ! defined( 'WP_USE_THEMES' ) ) {
	define( 'WP_USE_THEMES', false );
}
require_once ABSPATH . 'wp-admin/includes/admin.php';
show_admin_bar( false );

// Edit Profile Shortcode.
$shortcode = '[dr_edit_profile]';

// Get the user avatar.
$user_id        = get_current_user_id();
$user_avatar_id = get_user_meta( $user_id, 'user_avatar', true );
if ( $user_avatar_id ) {
	$user_avatar = wp_get_attachment_image_src( $user_avatar_id, 'thumbnail' );
	if ( $user_avatar ) {
		$user_avatar = '<img src="' . esc_url( $user_avatar[0] ) . '" alt="User Avatar" class="wpd-dp__user-avatar">';
	} else {
		$user_avatar = get_avatar( $user_id, 32, '', '', array( 'class' => 'wpd-dp__user-avatar' ) );
	}
} else {
	$user_avatar = get_avatar( $user_id, 32, '', '', array( 'class' => 'wpd-dp__user-avatar' ) );
}

// Global Settings Data.
$global_settings               = delicious_recipes_get_global_settings();
$dashboard_portal              = isset( $global_settings['dashboardPortal'] ) && is_array( $global_settings['dashboardPortal'] ) && 'yes' === $global_settings['dashboardPortal'][0] ? $global_settings['dashboardPortal'][0] : array();
$dashboard_portal_logo         = isset( $global_settings['dashboardPortalLogo'] ) && '' !== $global_settings['dashboardPortalLogo'] ? $global_settings['dashboardPortalLogo'] : '';
$dashboard_portal_logo_preview = isset( $global_settings['dashboardPortalLogoPreview'] ) && '' !== $global_settings['dashboardPortalLogoPreview'] ? $global_settings['dashboardPortalLogoPreview'] : '';
$dashboard_tabs                = array();
$active_tab                    = '';
if ( $dashboard_portal ) {
	$dashboard_tabs = isset( $global_settings['dashboardTabs'] ) && is_array( $global_settings['dashboardTabs'] ) ? $global_settings['dashboardTabs'] : array();
	if ( is_array( $dashboard_tabs ) && ! empty( $dashboard_tabs ) ) {
		$dashboard_tabs = array_filter(
			$dashboard_tabs,
			function ( $tab ) {
				return isset( $tab['enable'] ) && 'yes' === $tab['enable'][0];
			}
		);
	}
	// Get the active tab from the URL parameter, default to the first tab if not set.
	$active_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : $dashboard_tabs[0]['id'];
}

// Get the dashboard portal logo and site title.
$logo       = '';
$site_title = get_bloginfo( 'name' );
if ( '' !== $dashboard_portal_logo && '' !== $dashboard_portal_logo_preview ) {
	$logo = wp_get_attachment_image_src( $dashboard_portal_logo, 'full' );
	$logo = '<img src="' . esc_url( $logo[0] ) . '" alt="' . esc_attr( $site_title ) . '" class="wpd-dp__brand-logo">';
}

$defaults_tabs = array(
	array(
		'id'   => 'browse-recipes',
		'icon' => '<use xlink:href="#restaurant"></use>',
	),
	array(
		'id'   => 'favorites',
		'icon' => '<use xlink:href="#bookmark_check"></use>',
	),
	array(
		'id'   => 'submit-recipes',
		'icon' => '<use xlink:href="#arrow-narrow-up"></use>',
	),
	array(
		'id'   => 'my-recipes',
		'icon' => '<use xlink:href="#toque"></use>',
	),
);

// Add wp_head() to load scripts and styles.
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php
	wp_head();
	// Add Elementor frontend files if needed.
	if ( defined( 'ELEMENTOR_VERSION' ) ) {
		if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
			\Elementor\Plugin::$instance->frontend->enqueue_styles();
			\Elementor\Plugin::$instance->frontend->enqueue_scripts();
		} else {
			\Elementor\Plugin::$instance->frontend->enqueue_styles();
		}
	}
	?>
</head>

<body <?php body_class(); ?>>

	<div class="wpd-dashboard-portal">
		<div class="wpd-dashboard-portal__container">
			<aside class="wpd-dashboard-portal__sidebar">
				<div class="wpd-dp__sidebar-inner">
					<button id="wpd-dp__sidebar-close" type="button" class="wpd-dp__button wpd-dp__sidebar-close light">
						<span class="wpd-dp__icon">
							<svg>
								<use xlink:href="#x_close"></use>
							</svg>
						</span>
					</button>
					<div class="wpd-dp__brand-wrap">
						<div class="wpd-dp__brand">
							<?php if ( ! empty( $logo ) ) : ?>
								<?php echo wp_kses_post( $logo ); ?>
							<?php else : ?>
								<h2 class="wpd-dp__brand-title light"><?php echo esc_html( $site_title ); ?></h2>
							<?php endif; ?>
						</div>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" target="_blank" class="wpd-dp__button wpd-dp__brand-site-link light">
							<span class="wpd-dp__icon">
								<svg>
									<use xlink:href="#link-external"></use>
								</svg>
							</span>
							<?php esc_html_e( 'Visit Site', 'delicious-recipes-pro' ); ?>
						</a>
					</div>
					<div class="wpd-dp__tab wpd-dp__tab-vertical">
						<?php
						foreach ( $dashboard_tabs as $key => $tab ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
							// Skip if it's a link type with no link.
							if ( isset( $tab['contentType'] ) && 'link' === $tab['contentType'] && ( ! isset( $tab['link'] ) || empty( $tab['link'] ) ) ) {
								continue;
							}

							if ( ! empty( $tab['enable'][0] ) && 'yes' === $tab['enable'][0] ) :
								$is_active = ( $active_tab === $tab['id'] ) ? ' active' : '';
								$is_link   = isset( $tab['contentType'] ) && 'link' === $tab['contentType'];
								$link_url  = $is_link
									? ( isset( $tab['link'] ) && ! empty( $tab['link'] ) ? esc_url( $tab['link'] ) : '#' )
									: add_query_arg( 'tab', $tab['id'], $_SERVER['REQUEST_URI'] ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
								$target    = $is_link && isset( $tab['newTab'] ) && is_array( $tab['newTab'] ) && 'yes' === $tab['newTab'][0] ? ' target="_blank"' : '';

								// Use anchor tag for links, button for other types.
								$tag_open  = $is_link
									? sprintf( '<a href="%s"%s class="wpd-dp__button wpd-dp__tab-button light%s" data-tab="wpd-%s">', $link_url, $target, $is_active, esc_attr( $tab['id'] ) )
									: sprintf( '<button type="button" class="wpd-dp__button wpd-dp__tab-button light%s" data-tab="wpd-%s">', $is_active, esc_attr( $tab['id'] ) );
								$tag_close = $is_link ? '</a>' : '</button>';

								echo $tag_open; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								?>
									<?php
									// Check if we should show an icon.
									$show_icon        = false;
									$use_default_icon = false;

									// If tab['icon'] is an array with 'icon' key and it's empty, and id exists in defaults, use default icon.
									if ( is_array( $tab['icon'] ) && array_key_exists( 'icon', $tab['icon'] ) && empty( $tab['icon']['icon'] ) && in_array( $tab['id'], array_column( $defaults_tabs, 'id' ), true ) ) {
										$show_icon        = true;
										$use_default_icon = true;
									}
									// If tab['icon'] is an array with 'icon' key and it's not empty, use that.
									elseif ( is_array( $tab['icon'] ) && array_key_exists( 'icon', $tab['icon'] ) && ! empty( $tab['icon']['icon'] ) ) {
										$show_icon = true;
									}

									if ( $show_icon ) :
										?>
										<span class="wpd-dp__icon">
											<?php
											if ( $use_default_icon ) :
												// Find matching default tab and use its icon.
												$default_tab = array_filter(
													$defaults_tabs,
													function ( $dt ) use ( $tab ) {
														return $dt['id'] === $tab['id'];
													}
												);
												$default_tab = reset( $default_tab );
												echo '<svg>' . $default_tab['icon'] . '</svg>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
											elseif ( ! empty( $tab['icon']['icon'] ) ) :
												?>
													<svg viewBox="<?php echo esc_attr( $tab['icon']['view_box'] ); ?>" fill="currentColor">
														<path d="<?php echo esc_attr( $tab['icon']['path'] ); ?>"/>
													</svg>
												<?php
											endif;
											?>
										</span>
									<?php endif; ?>
									<?php echo esc_html( $tab['title'] ); ?>
								<?php
								echo $tag_close; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							endif;
						endforeach;
						?>
					</div>
				</div>
			</aside>
			<main class="wpd-dashboard-portal__content-wrap">
				<header class="wpd-dp__header">
					<div class="wpd-dp__header-container">
						<div class="wpd-dp__header-left">
							<button id="wpd-dp__sidebar-toggler" type="button" class="wpd-dp__sidebar-toggler">
								<span class="wpd-dp__icon">
									<svg>
										<use xlink:href="#menu"></use>
									</svg>
								</span>
							</button>
							<h1 class="wpd-dp__title">
								<?php
								if ( 'edit_profile' === $active_tab ) {
									$active_tab_title = esc_html__( 'Edit Profile', 'delicious-recipes-pro' );
								} else {
									$active_tab_title = $dashboard_tabs[0]['title'];
									foreach ( $dashboard_tabs as $tab ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
										if ( $tab['id'] === $active_tab ) {
											$active_tab_title = $tab['title'];
											break;
										}
									}
								}
								echo esc_html( $active_tab_title );
								?>
							</h1>
						</div>
						<div class="wpd-dp__header-right">
							<div class="wpd-dp__user-wrap">
								<div class="wpd-dp__user">
									<div class="wpd-dp__user-avatar">
										<?php echo $user_avatar; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
									</div>
									<button id="wpd-dp__user-dropdown-toggler" class="wpd-dp__button wpd-dp__user-dropdown-toggler">
										<span class="wpd-dp__icon">
											<svg>
												<use xlink:href="#angle-down"></use>
											</svg>
										</span>
									</button>
								</div>
								<div id="wpd-dp__user-dropdown" class="wpd-dp__user-dropdown">
									<button type="button" class="wpd-dp__button wpd-dp__tab-button<?php echo $active_tab === 'edit-profile' ? ' active' : ''; ?>" data-tab="wpd-edit-profile">
										<span class="wpd-dp__icon">
											<svg>
												<use xlink:href="#person_edit"></use>
											</svg>
										</span>
										<?php esc_html_e( 'Edit Profile', 'delicious-recipes-pro' ); ?>
									</button>
									<a href="<?php echo esc_url( wp_logout_url( isset( $_SERVER['REQUEST_URI'] ) ? wp_unslash( $_SERVER['REQUEST_URI'] ) : '/' ) ); ?>" class="wpd-dp__button wpd-dp__user-logout">
										<span class="wpd-dp__icon">
											<svg>
												<use xlink:href="#log_out"></use>
											</svg>
										</span>
										<?php esc_html_e( 'Log Out', 'delicious-recipes-pro' ); ?>
									</a>
								</div>
							</div>
						</div>
					</div>
				</header>
				<div class="wpd-dp__content">
					<h1 class="wpd-dp__title">
						<?php echo esc_html( $dashboard_tabs[0]['title'] ); ?>
					</h1>
					<div data-tab="wpd-edit-profile" class="wpd-dp__tab-content<?php echo $active_tab === 'edit-profile' ? ' active' : ''; ?>">
						<?php
						echo do_shortcode( '[dr_edit_profile]' );
						?>
					</div>
					<?php
					foreach ( $dashboard_tabs as $key => $tab ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
						if ( ! empty( $tab['enable'][0] ) && 'yes' === $tab['enable'][0] ) :
							$is_active = ( $active_tab === $tab['id'] ) ? ' active' : '';
							?>
							<div data-tab="wpd-<?php echo esc_attr( $tab['id'] ); ?>" class="wpd-dp__tab-content<?php echo esc_attr( $is_active ); ?>">
							<?php
								$use_default_tab = false;
							if ( in_array( $tab['id'], array_column( $defaults_tabs, 'id' ), true ) ) {
								$use_default_tab = true;
							}
							if ( ! empty( $tab['content'] ) && $use_default_tab ) {
								echo do_shortcode( $tab['content'] );
							} elseif ( isset( $tab['contentType'] ) && ! empty( $tab['contentType'] ) ) {
								if ( 'page' === $tab['contentType'] ) {
									if ( isset( $tab['page'] ) && ! empty( $tab['page'] ) ) {
										$page = get_post( $tab['page'] ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
										if ( $page ) {
											// Check if the page is built with Elementor.
											if ( class_exists( '\Elementor\Plugin' ) ) {
												$document = \Elementor\Plugin::$instance->documents->get( $page->ID );
												if ( $document && $document->is_built_with_elementor() ) {
													echo $document->get_content();
												} else {
													// If not Elementor, check for shortcodes or render regular content
													$content = $page->post_content;
													if ( has_shortcode( $content, '[' ) ) {
														echo do_shortcode( $content );
													} else {
														echo apply_filters( 'the_content', $content );
													}
												}
											} else {
												// If Elementor is not active, check for shortcodes or render regular content
												$content = $page->post_content;
												if ( has_shortcode( $content, '[' ) ) {
													echo do_shortcode( $content );
												} else {
													echo apply_filters( 'the_content', $content );
												}
											}
										}
									}
								}
							}
							?>
							</div>
							<?php
						endif;
					endforeach;
					?>
				</div>
			</main>
		</div>
	</div>

	<?php
	// Add wp_footer() to load footer scripts.
	wp_footer();
	?>

	<svg width="0" height="0" class="hidden">
		<symbol fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 16" id="arrow-narrow-up">
			<path d="M6 14.6668V1.3335M6 1.3335L1 6.3335M6 1.3335L11 6.3335" stroke="currentColor" stroke-width="1.67" stroke-linecap="round" stroke-linejoin="round"/>
		</symbol>
		<symbol fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 16" id="bookmark_check">
			<path d="M5.12502 9.66667L9.25002 5.54167L8.06252 4.375L5.12502 7.3125L3.93752 6.125L2.75002 7.3125L5.12502 9.66667ZM0.166687 15.5V2.16667C0.166687 1.70833 0.329881 1.31597 0.65627 0.989583C0.982659 0.663194 1.37502 0.5 1.83335 0.5H10.1667C10.625 0.5 11.0174 0.663194 11.3438 0.989583C11.6702 1.31597 11.8334 1.70833 11.8334 2.16667V15.5L6.00002 13L0.166687 15.5Z" fill="currentColor"/>
		</symbol>
		<symbol fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" id="toque">
			<path d="M11.4394 2.26394C10.8156 0.902981 9.48362 0 7.99986 0C6.5161 0 5.18414 0.902981 4.56166 2.26394C2.1973 1.76707 0 3.66523 0 6.16093C0 7.64573 0.771559 8.97215 1.99999 9.65911V15.3044C1.99999 15.6889 2.29812 16 2.66664 16H13.3334C13.7019 16 14 15.6889 14 15.3044V9.66022C15.2284 8.97181 16 7.64687 16 6.16204C16 3.66479 13.804 1.76659 11.4398 2.26357L11.4394 2.26394ZM13.0902 8.5677C12.8349 8.67139 12.6665 8.92918 12.6665 9.21577V11.1298H3.33329V9.21577C3.33329 8.92918 3.16491 8.67281 2.90957 8.5677C1.95169 8.17741 1.33334 7.23266 1.33334 6.16119C1.33334 4.73685 2.44443 3.57752 3.8095 3.57752C4.12281 3.57752 4.4306 3.63801 4.72183 3.75899C5.09174 3.91164 5.5072 3.69562 5.6107 3.29526C5.90331 2.17479 6.88605 1.39134 7.99989 1.39134C9.11374 1.39134 10.0965 2.17479 10.3891 3.29526C10.494 3.69561 10.9095 3.91166 11.278 3.75899C11.5692 3.63801 11.877 3.57752 12.1903 3.57752C13.5554 3.57752 14.6665 4.73685 14.6665 6.16119C14.6665 7.23266 14.0481 8.17745 13.0902 8.5677Z" fill="currentColor"/>
		</symbol>
		<symbol fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 14" id="restaurant">
			<path d="M16.9824 12.2108L16.2788 12.0853C16.2866 11.9623 16.2918 11.8289 16.2918 11.6824C16.2944 11.345 16.2709 10.9526 16.2055 10.5366C16.1715 10.33 16.127 10.1181 16.0669 9.90622C16.0067 9.69433 15.9361 9.48244 15.8497 9.27578C15.7634 9.06913 15.664 8.87032 15.5515 8.68198C15.439 8.49363 15.3161 8.31837 15.1853 8.15618C15.0545 7.99661 14.9185 7.85012 14.7825 7.72194C14.6464 7.59376 14.5078 7.47866 14.377 7.38449C14.2462 7.2877 14.1206 7.20399 14.0082 7.1386C13.9794 7.12029 13.9532 7.10459 13.9271 7.08889C13.9009 7.0732 13.8747 7.06012 13.8486 7.04442C13.7989 7.01565 13.7544 6.99211 13.7099 6.97118C13.6681 6.95025 13.6315 6.93194 13.5975 6.91363C13.5634 6.89793 13.5373 6.88485 13.5137 6.87439C13.4719 6.85346 13.4457 6.843 13.4431 6.843C13.4457 6.84562 13.4693 6.85869 13.5085 6.88224C13.5294 6.89532 13.5556 6.91101 13.587 6.93194C13.6184 6.95025 13.6524 6.97379 13.6916 6.99995C13.7309 7.02611 13.7727 7.05489 13.8198 7.08889C13.8434 7.10459 13.8669 7.1229 13.8904 7.14121C13.914 7.15952 13.9401 7.17783 13.9663 7.19876C14.0683 7.27724 14.1808 7.37141 14.2985 7.48128C14.4162 7.58853 14.5339 7.71409 14.649 7.85012C14.7668 7.98876 14.8792 8.14049 14.9839 8.30529C15.0885 8.47009 15.1853 8.64797 15.269 8.8337C15.3527 9.01943 15.4234 9.213 15.4809 9.41181C15.5385 9.608 15.5829 9.80943 15.6143 10.0109C15.6457 10.2097 15.664 10.4085 15.6745 10.5994C15.6928 10.984 15.6719 11.3423 15.6352 11.6458C15.6222 11.7583 15.6065 11.8655 15.5882 11.9623L0.967896 9.3281C1.66634 5.44872 5.81777 2.94793 10.2413 3.74316C14.6621 4.54101 17.6809 8.33145 16.9824 12.2108Z" fill="currentColor"/>
			<path d="M10.461 1.39167C9.90644 1.29227 9.37541 1.66111 9.27601 2.21568C9.1766 2.77025 9.54545 3.30128 10.1 3.40068C10.6546 3.50008 11.1856 3.13124 11.285 2.57667C11.3844 2.0221 11.0156 1.49107 10.461 1.39167ZM11.0051 2.10058C10.9633 2.33863 10.7357 2.49558 10.4976 2.45372C10.2596 2.41187 10.1026 2.18429 10.1445 1.94624C10.1863 1.70819 10.4139 1.55124 10.652 1.59309C10.89 1.63495 11.047 1.86253 11.0051 2.10058Z" fill="currentColor"/>
			<path d="M17.7123 13.3411H0.287749C0.128179 13.3411 0 13.2103 0 13.0534C0 12.8938 0.130795 12.7656 0.287749 12.7656H17.7123C17.8718 12.7656 18 12.8964 18 13.0534C18 13.2129 17.8718 13.3411 17.7123 13.3411Z" fill="currentColor"/>
			<path d="M0.949566 6.02454C1.09606 6.41431 1.09606 6.76484 0.988805 7.01858C0.892017 7.27232 0.687976 7.43189 0.69844 7.43189C0.68536 7.43189 0.766453 7.27494 0.737678 7.01858C0.719367 6.76484 0.593804 6.41169 0.447314 6.02454C0.300824 5.63477 0.300824 5.28424 0.408075 5.0305C0.504864 4.77676 0.708904 4.61719 0.69844 4.61719C0.711519 4.61719 0.630427 4.77414 0.659202 5.0305C0.677513 5.28424 0.805692 5.63477 0.949566 6.02454Z" fill="currentColor"/>
			<path d="M1.49888 4.61194C1.64537 5.00171 1.64537 5.35224 1.53812 5.60598C1.44133 5.85973 1.23729 6.0193 1.24776 6.0193C1.23468 6.0193 1.31577 5.86234 1.28699 5.60598C1.26868 5.35224 1.14312 4.9991 0.99663 4.61194C0.85014 4.22217 0.85014 3.87164 0.957392 3.6179C1.05418 3.36416 1.25822 3.20459 1.24776 3.20459C1.26084 3.20459 1.17974 3.36154 1.20852 3.6179C1.22683 3.87164 1.35501 4.22217 1.49888 4.61194Z" fill="currentColor"/>
			<path d="M4.71123 1.40735C4.56474 1.79712 4.56474 2.14765 4.67199 2.4014C4.76878 2.65514 4.97282 2.81471 4.96236 2.81471C4.97544 2.81471 4.89434 2.65775 4.92312 2.4014C4.94143 2.14765 5.06699 1.79451 5.21348 1.40735C5.35997 1.01758 5.35997 0.667054 5.25272 0.413312C5.15593 0.15957 4.95189 0 4.96236 0C4.94928 0 5.03037 0.156954 5.00159 0.413312C4.98328 0.667054 4.85772 1.01758 4.71123 1.40735Z" fill="currentColor"/>
		</symbol>
		<symbol viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" id="link-external">
			<path d="M17.5 7.5L17.5 2.5M17.5 2.5H12.5M17.5 2.5L10.8333 9.16667M8.33333 4.16667H6.5C5.09987 4.16667 4.3998 4.16667 3.86502 4.43915C3.39462 4.67883 3.01217 5.06129 2.77248 5.53169C2.5 6.06647 2.5 6.76654 2.5 8.16667V13.5C2.5 14.9001 2.5 15.6002 2.77248 16.135C3.01217 16.6054 3.39462 16.9878 3.86502 17.2275C4.3998 17.5 5.09987 17.5 6.5 17.5H11.8333C13.2335 17.5 13.9335 17.5 14.4683 17.2275C14.9387 16.9878 15.3212 16.6054 15.5608 16.135C15.8333 15.6002 15.8333 14.9001 15.8333 13.5V11.6667" stroke="currentColor" stroke-width="1.67" stroke-linecap="round" stroke-linejoin="round" />
		</symbol>
		<symbol viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" id="menu">
			<path d="M3 12H21M3 6H21M3 18H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
		</symbol>
		<symbol viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" id="angle-down">
			<path d="M5 7.5L10 12.5L15 7.5" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
		</symbol>
		<symbol viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg" id="person_edit">
			<path d="M12.2983 17.5002V14.9377L16.9025 10.3543C17.0275 10.2293 17.1664 10.1391 17.3191 10.0835C17.4719 10.0279 17.6247 10.0002 17.7775 10.0002C17.9441 10.0002 18.1039 10.0314 18.2566 10.0939C18.4094 10.1564 18.5483 10.2502 18.6733 10.3752L19.4441 11.146C19.5552 11.271 19.642 11.4099 19.7045 11.5627C19.767 11.7154 19.7983 11.8682 19.7983 12.021C19.7983 12.1738 19.7705 12.33 19.715 12.4897C19.6594 12.6495 19.5691 12.7918 19.4441 12.9168L14.8608 17.5002H12.2983ZM3.96497 16.6668V14.3335C3.96497 13.8613 4.08649 13.4272 4.32955 13.0314C4.5726 12.6356 4.89552 12.3335 5.2983 12.1252C6.15941 11.6946 7.03441 11.3717 7.9233 11.1564C8.81219 10.9411 9.71497 10.8335 10.6316 10.8335C11.1455 10.8335 11.6525 10.8647 12.1525 10.9272C12.6525 10.9897 13.1525 11.0904 13.6525 11.2293L10.6316 14.2502V16.6668H3.96497ZM17.7775 12.8335L18.5483 12.021L17.7775 11.2502L16.9858 12.0418L17.7775 12.8335ZM10.6316 10.0002C9.71497 10.0002 8.93024 9.67377 8.27747 9.021C7.62469 8.36822 7.2983 7.5835 7.2983 6.66683C7.2983 5.75016 7.62469 4.96544 8.27747 4.31266C8.93024 3.65989 9.71497 3.3335 10.6316 3.3335C11.5483 3.3335 12.333 3.65989 12.9858 4.31266C13.6386 4.96544 13.965 5.75016 13.965 6.66683C13.965 7.5835 13.6386 8.36822 12.9858 9.021C12.333 9.67377 11.5483 10.0002 10.6316 10.0002Z" fill="currentColor" />
		</symbol>
		<symbol viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg" id="log_out">
			<path d="M5.63163 6.66667L2.2983 10M2.2983 10L5.63163 13.3333M2.2983 10H13.1316M8.13163 3.50337C9.19393 2.86523 10.4273 2.5 11.7427 2.5C15.7315 2.5 18.965 5.85786 18.965 10C18.965 14.1421 15.7315 17.5 11.7427 17.5C10.4273 17.5 9.19393 17.1348 8.13163 16.4966" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
		</symbol>
		<symbol viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" id="x_close">
			<path d="M15 5L5 15M5 5L15 15" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
		</symbol>
	</svg>
</body>
</html>