<?php

/**
 * The template for displaying equipment content in archive.
 *
 * This template can be overridden by copying it to yourtheme/delicious-recipes-pro/equipments-grid.php.
 *
 * HOWEVER, on occasion WP Delicious will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://wpdelicious.com/docs/template-structure/
 * @package Delicious_Recipes/Templates
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

global $post;
$img_size = apply_filters( 'recipe_equipment_img_size', 'full' );

// Get equipment metas.
$equipment_meta = get_post_meta( $post->ID, 'delicious_recipes_equipment_metadata', true );
$link           = isset( $equipment_meta['equipmentLink'] ) && $equipment_meta['equipmentLink'] ? $equipment_meta['equipmentLink'] : '';
$label          = isset( $equipment_meta['equipmentLinkLabel'] ) && $equipment_meta['equipmentLinkLabel'] ? $equipment_meta['equipmentLinkLabel'] : __( 'Buy Now', 'delicious-recipes-pro' );
$tag_label      = isset( $equipment_meta['equipmentTagLabel'] ) && $equipment_meta['equipmentTagLabel'] ? $equipment_meta['equipmentTagLabel'] : '';
$no_follow      = isset( $equipment_meta['addRelNofollow']['0'] ) && 'yes' === $equipment_meta['addRelNofollow']['0'] ? 'nofollow' : '';
$sponsored      = isset( $equipment_meta['addRelSponsored']['0'] ) && 'yes' === $equipment_meta['addRelSponsored']['0'] ? 'sponsored' : '';
$new_tab        = isset( $equipment_meta['openInNewWindow']['0'] ) && 'yes' === $equipment_meta['openInNewWindow']['0'] ? '_blank' : '_self';
$rel            = implode( ' ', array( $no_follow, $sponsored ) );

$terms = get_the_terms( $post->ID, 'equipment-category' );
if ( is_wp_error( $terms ) ) {
	return;
}
$term_slug = '';
$use_count = '';
if ( is_array( $terms ) ) {
	foreach ( $terms as $term ) {
		if ( ! empty( $term->slug ) ) {
			$term_slug .= $term->slug . ' ';
		}
	}
}

$recipe_args  = array(
	'post_type'      => 'recipe',
	'posts_per_page' => -1,
	'meta_query'     => array(
		array(
			'key'     => 'delicious_recipes_metadata',
			'value'   => $post->ID,
			'compare' => 'LIKE',
		),
	),
);
$recipe_query = new WP_Query( $recipe_args );
if ( $recipe_query->have_posts() ) {
	$use_count = count( $recipe_query->posts );
}
if ( empty( $use_count ) ) {
	$use_count = 0;
}
?>
<div class="wpd-equipment-item-wrap wpd-filter-item <?php echo esc_attr( $term_slug ); ?>" data-id="<?php echo esc_attr( $post->ID ); ?>" data-use-count="<?php echo esc_attr( $use_count ); ?>">
	<div class="wpd-equipment">
		<?php if ( ! empty( $tag_label ) ) { ?>
			<div class="wpd-equipment-tags">
				<span class="wpd-tag">
					<?php
					echo esc_html__( $tag_label, 'delicious-recipes-pro' );
					?>
				</span>
			</div>
		<?php } ?>
		<div class="wpd-equipment-image-wrap">
			<?php if ( get_the_post_thumbnail_url( $post->ID, $img_size ) ) : ?>
				<a href="<?php echo esc_url( $link ); ?>" rel="<?php echo esc_attr( $rel ); ?>" target="<?php echo esc_attr( $new_tab ); ?>" class="wpd-equipment-link">
					<img src="<?php echo esc_url( get_the_post_thumbnail_url( $post->ID, $img_size ) ); ?>" alt="">
				</a>
			<?php else : ?>
				<div class="image-placeholder"></div>
			<?php endif; ?>
		</div>
		<div class="wpd-equipment-details-wrap">
			<h3 class="wpd-equipment-title">
				<?php
				echo esc_html__( $post->post_title, 'delicious-recipes-pro' );
				?>
			</h3>
			<div class="wpd-equipment-content">
				<p class="wpd-equipment-description">
					<?php echo wp_kses_post( $post->post_content, 'delicious-recipes-pro' ); ?>
				</p>
			</div>
			<a href="<?php echo esc_url( $link ); ?>" rel="<?php echo esc_attr( $rel ); ?>" target="<?php echo esc_attr( $new_tab ); ?>" class="wpd-equipment-btn"><?php echo esc_html__( $label, 'delicious-recipes-pro' ); ?></a>
		</div>
	</div>
</div>
<?php
